﻿//DESCRIPTION:Break all 2-page spreads into separate non-facing pages spaced 1/2" apart

// Modified 2023-06-21
// Keith Gilbert, Gilbert Consulting
// www.gilbertconsulting.com

Pre();
  
function Pre () { 
	// Check to make sure at least 1 ID file is open
	if (!app.documents.length) { 
		alert("No InDesign documents are open. Please open a document and try again.");
		return;
	} 
	// Main();
	app.doScript('Main();', undefined, [], UndoModes.ENTIRE_SCRIPT,"Run Script"); // This makes the script un-doable
}  
function Main() {
	var myResponse = myDialog1();
	if (!myResponse) {
		return;
	}
	var myDoc = app.activeDocument;
    var myHorizontal = myDoc.viewPreferences.horizontalMeasurementUnits;
    var myVertical = myDoc.viewPreferences.verticalMeasurementUnits;
    //Set the measurement units to points.
    myDoc.viewPreferences.horizontalMeasurementUnits = MeasurementUnits.points;
    myDoc.viewPreferences.verticalMeasurementUnits = MeasurementUnits.points;
	var mySide = "right";
	if ((myDoc.pages[0].side == PageSideOptions.SINGLE_SIDED) && (myDoc.spreads[0].pages.length > 1)) { // Single-sided and the first spread is a spread, so count page as a left-hand page
		mySide = "left";
	}
	else {
		if (myDoc.pages[0].side == PageSideOptions.LEFT_HAND) { // First page is a left-hand page
			mySide = "left";
		}
	}
	// Turn OFF Allow Document Pages to Shuffle
	myDoc.documentPreferences.allowPageShuffle = false;
	// Switch from facing pages to non-facing pages
	if (myDoc.documentPreferences.facingPages == true) {
		var myMarginArray = new Array;
		// Memorize the margins on every page page, to be reapplied later, since changing from facing pages to non-facing pages will move the page items if the margins are not equal zero
		for (var i=0; i<myDoc.pages.length; i++) {
			var myPage = myDoc.pages[i];
			myMarginArray.push([myPage.marginPreferences.left, myPage.marginPreferences.right]);
			myPage.marginPreferences.left = 0;
			myPage.marginPreferences.right = 0;
		}
		myDoc.documentPreferences.facingPages = false;
		// Reapply the margins
		for (var i=0; i<myDoc.pages.length; i++) {
			var myPage = myDoc.pages[i];
			if (myPage.documentOffset % 2 == 0) { // Even page
				myPage.marginPreferences.left = myMarginArray[i][0];
				myPage.marginPreferences.right = myMarginArray[i][1];
			}
			else { // Odd page
				myPage.marginPreferences.left = myMarginArray[i][1];
				myPage.marginPreferences.right = myMarginArray[i][0];
			}
		}	
	}
	// Move every odd page 1/2" to the right
	var myTranslateMatrix = app.transformationMatrices.add({horizontalTranslation:18.1, verticalTranslation:0});
	var myIndex = 0;
	if (mySide == "left") {
		myIndex = 1;
	}
	for (var i=myIndex; i<myDoc.pages.length; i=i+2) {
		var myPage = myDoc.pages[i];
		myPage.transform(CoordinateSpaces.PASTEBOARD_COORDINATES, AnchorPoint.CENTER_ANCHOR, myTranslateMatrix);
		myAdjustPage(myPage, 18.1, 0);
	}
    //Reset the measurement units to their original values.
    myDoc.viewPreferences.horizontalMeasurementUnits = myHorizontal;
    myDoc.viewPreferences.verticalMeasurementUnits = myVertical;
	beep();
	myDialog2();
}
// Move objects on the page by the specified amount
function myAdjustPage(myPage, myX, myY){
	var myPageItem;
	for(var myCounter = 0; myCounter < myPage.pageItems.length; myCounter ++){
		var myResetItemLock = false;
		var myResetLayerLock = false;
		myPageItem = myPage.pageItems.item(myCounter);
		if(myPageItem.locked == true){
			myPageItem.locked = false;
			myResetItemLock = true;
		}
		if(myPageItem.itemLayer.locked == true){
			myPageItem.itemLayer.locked = false;
			myResetLayerLock = true;
		}
		myPageItem.move(undefined, [myX, myY]);
		if(myResetItemLock == true){
			myPageItem.locked = true;
		}
		if(myResetLayerLock == true){
			myPageItem.itemLayer.locked = true;
		}
	}
}
// Display a dialog box
function myDialog1() {
	/*
	Code for Import https://scriptui.joonas.me — (Triple click to select): 
	{"activeId":1,"items":{"item-0":{"id":0,"type":"Dialog","parentId":false,"style":{"enabled":true,"varName":null,"windowType":"Dialog","creationProps":{"su1PanelCoordinates":false,"maximizeButton":false,"minimizeButton":false,"independent":false,"closeButton":true,"borderless":false,"resizeable":false},"text":"Separate pages","preferredSize":[0,0],"margins":16,"orientation":"column","spacing":10,"alignChildren":["right","top"]}},"item-1":{"id":1,"type":"StaticText","parentId":0,"style":{"enabled":true,"varName":null,"creationProps":{},"softWrap":true,"text":"This script will separate all 2-page spreads in the document by 1/4\". This is useful for documents destined for print output that may contain a bleed on the spine, such as spiral-bound publications.\n\nPlease note that all objects on every right-hand page will also be moved 1/4\" to the right, so that their position on the page remains constant.\n\nAlso, the margins on every left-hand page will be overridden from the Parent page that is applied to the page.\n\nPlease proof the results carefully when the script is finished!","justify":"left","preferredSize":[400,0],"alignment":null,"helpTip":null}},"item-2":{"id":2,"type":"Group","parentId":0,"style":{"enabled":true,"varName":null,"preferredSize":[0,0],"margins":[11,0,0,0],"orientation":"row","spacing":10,"alignChildren":["left","center"],"alignment":null}},"item-3":{"id":3,"type":"Button","parentId":2,"style":{"enabled":true,"varName":"ok","text":"OK","justify":"center","preferredSize":[78,0],"alignment":null,"helpTip":null}},"item-4":{"id":4,"type":"Button","parentId":2,"style":{"enabled":true,"varName":"cancel","text":"Cancel","justify":"center","preferredSize":[79,0],"alignment":null,"helpTip":null}}},"order":[0,1,2,4,3],"settings":{"importJSON":true,"indentSize":false,"cepExport":false,"includeCSSJS":true,"showDialog":true,"functionWrapper":false,"afterEffectsDockable":false,"itemReferenceList":"None"}}
	*/ 
	
	// DIALOG
	// ======
	var dialog = new Window("dialog"); 
		dialog.text = "Separate pages"; 
		dialog.orientation = "column"; 
		dialog.alignChildren = ["right","top"]; 
		dialog.spacing = 10; 
		dialog.margins = 16; 
	
	var statictext1 = dialog.add("group", undefined , {name: "statictext1"}); 
		statictext1.getText = function() { var t=[]; for ( var n=0; n<statictext1.children.length; n++ ) { var text = statictext1.children[n].text || ''; if ( text === '' ) text = ' '; t.push( text ); } return t.join('\n'); }; 
		statictext1.preferredSize.width = 400; 
		statictext1.orientation = "column"; 
		statictext1.alignChildren = ["left","center"]; 
		statictext1.spacing = 0; 
	
		statictext1.add("statictext", undefined, "This script will separate all 2-page spreads in the document by"); 
		statictext1.add("statictext", undefined, "1/4\u0022. This is useful for documents destined for print output that"); 
		statictext1.add("statictext", undefined, "may contain a bleed on the spine, such as spiral-bound"); 
		statictext1.add("statictext", undefined, "publications. "); 
		statictext1.add("statictext", undefined, ""); 
		statictext1.add("statictext", undefined, "Please note that all objects on every right-hand page will also"); 
		statictext1.add("statictext", undefined, "be moved 1/4\u0022 to the right, so that their position on the page"); 
		statictext1.add("statictext", undefined, "remains constant. "); 
		statictext1.add("statictext", undefined, ""); 
		statictext1.add("statictext", undefined, "Also, the margins on every left-hand page will be overridden"); 
		statictext1.add("statictext", undefined, "from the Parent page that is applied to the page. "); 
		statictext1.add("statictext", undefined, ""); 
		statictext1.add("statictext", undefined, "Please proof the results carefully when the script is finished!"); 
	
	// GROUP1
	// ======
	var group1 = dialog.add("group", undefined, {name: "group1"}); 
		group1.orientation = "row"; 
		group1.alignChildren = ["left","center"]; 
		group1.spacing = 10; 
		group1.margins = [0,11,0,0]; 
	
	var cancel = group1.add("button", undefined, undefined, {name: "cancel"}); 
		cancel.text = "Cancel"; 
		cancel.preferredSize.width = 79; 
	
	var ok = group1.add("button", undefined, undefined, {name: "ok"}); 
		ok.text = "OK"; 
		ok.preferredSize.width = 78; 

	// End ScriptUI code
	if (dialog.show () == 1) {
		return true;
	}
	else {
		exit ();
	}
}
// Display a dialog box
function myDialog2() {
	/*
	Code for Import https://scriptui.joonas.me — (Triple click to select): 
	{"activeId":0,"items":{"item-0":{"id":0,"type":"Dialog","parentId":false,"style":{"enabled":true,"varName":null,"windowType":"Dialog","creationProps":{"su1PanelCoordinates":false,"maximizeButton":false,"minimizeButton":false,"independent":false,"closeButton":true,"borderless":false,"resizeable":false},"text":"Separate pages","preferredSize":[0,0],"margins":16,"orientation":"column","spacing":10,"alignChildren":["center","top"]}},"item-1":{"id":1,"type":"StaticText","parentId":0,"style":{"enabled":true,"varName":null,"creationProps":{},"softWrap":true,"text":"Done!\n\nHas this script saved you time? Donations welcome here:\nwww.buymeacoffee.com/keithgilbert","justify":"center","preferredSize":[400,0],"alignment":null,"helpTip":null}},"item-2":{"id":2,"type":"Group","parentId":0,"style":{"enabled":true,"varName":null,"preferredSize":[0,0],"margins":[11,0,0,0],"orientation":"row","spacing":10,"alignChildren":["left","center"],"alignment":null}},"item-3":{"id":3,"type":"Button","parentId":2,"style":{"enabled":true,"varName":"ok","text":"OK","justify":"center","preferredSize":[78,0],"alignment":null,"helpTip":null}}},"order":[0,1,2,3],"settings":{"importJSON":true,"indentSize":false,"cepExport":false,"includeCSSJS":true,"showDialog":true,"functionWrapper":false,"afterEffectsDockable":false,"itemReferenceList":"None"}}
	*/ 
	
	// DIALOG
	// ======
	var dialog = new Window("dialog"); 
		dialog.text = "Separate pages"; 
		dialog.orientation = "column"; 
		dialog.alignChildren = ["center","top"]; 
		dialog.spacing = 10; 
		dialog.margins = 16; 
	
	var statictext1 = dialog.add("group", undefined , {name: "statictext1"}); 
		statictext1.getText = function() { var t=[]; for ( var n=0; n<statictext1.children.length; n++ ) { var text = statictext1.children[n].text || ''; if ( text === '' ) text = ' '; t.push( text ); } return t.join('\n'); }; 
		statictext1.preferredSize.width = 400; 
		statictext1.orientation = "column"; 
		statictext1.alignChildren = ["center","center"]; 
		statictext1.spacing = 0; 
	
		statictext1.add("statictext", undefined, "Done! "); 
		statictext1.add("statictext", undefined, ""); 
		statictext1.add("statictext", undefined, "Has this script saved you time? Donations welcome here:"); 
		statictext1.add("statictext", undefined, "www.buymeacoffee.com/keithgilbert"); 
	
	// GROUP1
	// ======
	var group1 = dialog.add("group", undefined, {name: "group1"}); 
		group1.orientation = "row"; 
		group1.alignChildren = ["left","center"]; 
		group1.spacing = 10; 
		group1.margins = [0,11,0,0]; 
	
	var ok = group1.add("button", undefined, undefined, {name: "ok"}); 
		ok.text = "OK"; 
		ok.preferredSize.width = 78; 
	
	dialog.show();
		
	// End ScriptUI code
	exit();
}